#include "USB_PD.H"
U8 pd_state = 0, pd_last_state, timeout_state = 0;
U16 opt_max_curr, pd_flags = 0, timeout_counter = 0;
U8 pd_messageid = 0;
U8 PD_TX_length;
bit pd_new_request;
bit flag_check_port;

U8 pdo_index = 0;


void set_input_current_limit(U16 ma)
{
    opt_max_curr = ma ;
}

U16 get_src_pdo_fixedsupply_maxvolt(U32 pdo)
{
    return (pdo >> 10) & 0x3FF ;     //B19~10 Voltage in 50mV units
}
U16 get_src_pdo_fixedsupply_maxcurr(U32 pdo)
{
    return (U16)(pdo & 0x000003FF) ;      //B9~0 Current in 10mA units
}

void pd_set_state(U8 next_state)
{
    pd_last_state = pd_state;
    pd_state = next_state;

    if (next_state == pd_last_state)
        return;

    if (next_state == PD_STATE_SNK_DISCONNECTED)
    {
        pd_flags = 0;

        set_input_current_limit(0);
    }

}
void set_timeout_state(U16 timeout, U8 next_state)
{
    timeout_counter = timeout;
    timeout_state = next_state;
    Timer_ms = 0;
}
U8 get_src_pdo_powertype(U8 PDO)
{

    switch (PDO  & 0xC0)
    {
        case 0:
            return FIXED_SUPPLY;

        case 0x40:
            return BATTERY;

        case 0x80:
            return VARIABLE_SUPPLY;

        case 0xC0:
            return AUGMENTED_POWER;
        default:
            return RESERVED;
    }

}

U8 get_header_field(U8 FIELD)
{

    switch (FIELD)
    {
        case MSG_TYPE:
            return Header_Lowbyte & 0x1F;

        case DATA_ROLE:
            return (Header_Lowbyte & 0x20) >> 5 ;

        case SPEC_REV:
            return (Header_Lowbyte & 0xC0) >> 6 ;

        case POWER_ROLE:
            return Header_Highbyte & 0x01 ;

        case MESSAGEID:
            return (Header_Highbyte & 0x0E) >> 1 ;

        case DATA_OBJECTS:
            return (Header_Highbyte & 0x70) >> 4 ;

        case EXTENDED:
            return (Header_Highbyte & 0x80) >> 7 ;
        default:
            return 0;
    }

}

void pd_process_source_cap()
{
    U8 i;
    U16 result;


    for (i = 0; i < 7; i++)
        PD_Source_PDO[i].DW = 0;


    Support_5V_Flag = Support_9V_Flag = Support_12V_Flag = Support_15V_Flag = Support_20V_Flag = 0;
    SUP_LED_5V = SUP_LED_9V = SUP_LED_12V = SUP_LED_15V = SUP_LED_20V = DRV_OFF;

    for (i = 0; i <= get_header_field(DATA_OBJECTS); i++)
    {
        PD_Source_PDO[i].B[3] = PD_RXdata[i * 4 + 2 ];
        PD_Source_PDO[i].B[2] = PD_RXdata[i * 4 + 2 + 1];
        PD_Source_PDO[i].B[1] = PD_RXdata[i * 4 + 2 + 2];
        PD_Source_PDO[i].B[0] = PD_RXdata[i * 4 + 2 + 3];

        if (get_src_pdo_powertype(PD_Source_PDO[i].B[0]) == FIXED_SUPPLY)
        {

            result = get_src_pdo_fixedsupply_maxvolt(PD_Source_PDO[i].DW);

            if (result == 100)      //100*50mV = 5V
            {
                Support_5V_Flag = 1;
                SUP_LED_5V = DRV_ON;//i = 0 , index 1 is 5Vprog
            }
            else if (result == 180)   //180*50mV = 9V
            {
                Support_9V_Flag = 1;
                PDO_9V_index = i;
                SUP_LED_9V = DRV_ON;

            }
            else if (result == 240)   //240*50mV = 12V
            {
                Support_12V_Flag = 1;
                PDO_12V_index = i;
                SUP_LED_12V = DRV_ON;
            }
            else if (result == 300)   //300*50mV = 15V
            {
                Support_15V_Flag = 1;
                PDO_15V_index = i;
                SUP_LED_15V = DRV_ON;
            }
            else if (result == 400)   //400*50mV = 20V
            {
                Support_20V_Flag = 1;
                PDO_20V_index = i;
                SUP_LED_20V = DRV_ON;
            }
        }
    }

}
void pd_request_msg(U32 index)
{
    DWTYPE fixed_pdo;
    U32 reg;
    fixed_pdo.DW = ((index + 1) << 28) | GIVEBACK;

    reg = get_src_pdo_fixedsupply_maxcurr(PD_Source_PDO[index].DW);
    fixed_pdo.DW |= (reg << 10) | reg;
    PD_TXdata[2] = fixed_pdo.B[3];
    PD_TXdata[3] = fixed_pdo.B[2];
    PD_TXdata[4] = fixed_pdo.B[1];
    PD_TXdata[5] = fixed_pdo.B[0];
}
void run_crc32(U8 dta[], U8 size)
{
    U32 crc = 0xFFFFFFFF;
    U8 i;
    SFRPI = AUXR12_Page;
    AUXR1 &= ~(CRCDS1 | CRCDS0);        //CRC0 0 L
    CRC0DA = 0xFF;
    AUXR1 |= CRCDS0;                    //CRC0 1 H
    CRC0DA = 0xFF;
    AUXR12 |= CRCDS2;                   //CRC0 3
    CRC0DA = 0xFF;
    AUXR1 &= ~CRCDS0;                   //CRC0 2
    CRC0DA = 0xFF;
    AUXR12 &= ~CRCDS2;
    AUXR1 |= CRCDS1 | CRCDS0;           //CRC0DI

    for (i = 0; i < size; i++)
    {
        BOREV = dta[i];
        CRC0DA = BOREV;
    }

    SFRPI = 0;
}

void pd_send_data_msg(U8 MsgType)
{
    DWTYPE pd_data[7] = 0;
    uint32_t pd_data0 = 0;
    U8  data_objects;

    switch (MsgType)
    {
        case PD_SINK_CAPABILITIES:  //Fixed Supply PDO - Sink
            data_objects  = 1;
            pd_data[0].DW = SINK_FIXED_SUPPLY | SINK_DUAL_ROLE_POWER | SINK_HIGHER_CAP | SINK_UNCON_POWER
                            | SINK_USB_COMM | SINK_OPERATIONAL_VOLTAGE  | SINK_OPERATIONAL_CURRENT;
            PD_TXdata[2] = pd_data[0].B[3];
            PD_TXdata[3] = pd_data[0].B[2];
            PD_TXdata[4] = pd_data[0].B[1];
            PD_TXdata[5] = pd_data[0].B[0];
            break;

        default:
            break;
    }


    Header_Highbyte = ((data_objects & 0x07) << 4)  | (pd_messageid & 0x07) << 1 | SINK;
    Header_Lowbyte = V30 | UFP | (MsgType  & 0x1F);

    PD_TXdata[0] = Header_Lowbyte;
    PD_TXdata[1] = Header_Highbyte;

    run_crc32(PD_TXdata, 2 + (data_objects * 4));

    AUXR1 &= ~(CRCDS1 | CRCDS0);                    //CRC0 0
    BOREV = CRC0DA;
    PD_TXdata[data_objects * 4 + 5] = ~BOREV;
    AUXR1 |= CRCDS0;                                //CRC0 1
    BOREV = CRC0DA;
    PD_TXdata[data_objects * 4 + 4]  = ~BOREV;
    AUXR1 |= CRCDS1;                                //CRC0 3
    BOREV = CRC0DA;
    PD_TXdata[data_objects * 4 + 2]  = ~BOREV;
    AUXR1 &= ~CRCDS0;                               //CRC0 2
    BOREV = CRC0DA;
    PD_TXdata[data_objects * 4 + 3]  = ~BOREV;

    retry_counter = 0;

    PD_TX_length = data_objects * 4 + 6; //data_objects*4byte + 2byte header + 4byte crc
    pd_transmit_packet();

}
void pd_send_hard_reset()
{
    pd_flags |= PD_FLAGS_SEND_HARD_RESET;
    pd_transmit_packet();
}

void pd_send_control_msg(U8 MsgType)
{
    U8  data_objects;

    data_objects  = 0;

    Header_Highbyte = ((data_objects & 0x07) << 4)  | (pd_messageid & 0x07) << 1 | SINK;
    Header_Lowbyte = V30 | UFP | (MsgType  & 0x1F);

    PD_TXdata[0] = Header_Lowbyte;
    PD_TXdata[1] = Header_Highbyte;

    run_crc32(PD_TXdata, 2);

    // read crc32 result
    AUXR1 &= ~(CRCDS1 | CRCDS0);        //CRC0 0
    BOREV = CRC0DA;
    PD_TXdata[5] = ~BOREV;
    AUXR1 |= CRCDS0;                    //CRC0 1
    BOREV = CRC0DA;
    PD_TXdata[4] = ~BOREV;
    AUXR1 |= CRCDS1;                    //CRC0 3
    BOREV = CRC0DA;
    PD_TXdata[2] = ~BOREV;
    AUXR1 &= ~CRCDS0;                   //CRC0 2
    BOREV = CRC0DA;
    PD_TXdata[3] = ~BOREV;

    retry_counter = 0;
    PD_TX_length = 6;   //2byte header + 4byte crc
    pd_transmit_packet();
}
void pd_send_request_msg(U8 index)
{
    U8  data_objects;

    data_objects = 1;
    Header_Highbyte = ((data_objects) << 4)  | (pd_messageid & 0x07) << 1 | SINK;
    Header_Lowbyte = V30 | UFP | PD_REQUEST ;

    PD_TXdata[0] = Header_Lowbyte;
    PD_TXdata[1] = Header_Highbyte;
    pd_request_msg(index);


    run_crc32(PD_TXdata, 6);

    // read crc32 result
    AUXR1 &= ~(CRCDS1 | CRCDS0);        //CRC0 0 L
    BOREV = CRC0DA;
    PD_TXdata[9] = ~BOREV;
    AUXR1 |= CRCDS0;                    //CRC0 1 H
    BOREV = CRC0DA;
    PD_TXdata[8] = ~BOREV;
    AUXR1 |= CRCDS1;                    //CRC0 3
    BOREV = CRC0DA;
    PD_TXdata[6] = ~BOREV;
    AUXR1 &= ~CRCDS0;                   //CRC0 2
    BOREV = CRC0DA;
    PD_TXdata[7] = ~BOREV;


    retry_counter = 0;
    PD_TX_length = 10;          //2byte header + 4byte data + 4byte crc

    pd_transmit_packet();

}



void pd_transmit_packet()
{
    __DRV_END45_mode(BMC_4bto5b);
    SFRPI = 0;
    PD_TX_Count = PD_TX_Field = 0;
    CC_bus_latch();
    PD_Communication_Status = TRANSFER;
    SFRPI = 1;
    TI1 = 1;
    SFRPI = 0;
}


void Check_Rp(cc_pin)
{
    U8 i;
    WTYPE ResultADC;

    SFRPI = 1;

    if ((S1CFG6 & M6IDL1) == 0)
    {
        SFRPI = 0;
        return;     //The engine is going on receive RXD1
    }

    SFRPI = 0;

    if (flag_check_port)
    {

        flag_check_port = 0;
        ResultADC.W = 0;
        ADC_Channel_Select(cc_pin);

        for (i = 0; i < 4; i++)
        {
            ADC_StartConversion();            //detect CC pin voltage

            while (ADC_GetConversionFlag() == DRV_Clr);

            ADC_ClearFlag();
            ResultADC.W += ADC_GetConversionData();;
        }

        ResultADC.W = ResultADC.W >> 2;       //average

        
        if (ResultADC.W < VRa_MAX)
        {
            CCDebounce ++;                       //Unknown power source
            if (CCDebounce >= 2)                //tPDdebounce 10ms~20ms
            {
                CCDebounce = USB_Port_Status = DetectDevice = PD_Communication_Status = PD_RX_Field = 0;
                pd_set_state(PD_STATE_SNK_DISCONNECTED);
                EIE1 &= ~ES1;        //Disable UART1 Interrupt
            }
        }
        else
            CCDebounce = 0;

        SFRPI = 0;
    }

}


void Check_USB_vbus()
{
    U8 i;
    WTYPE ResultADC;

    if (flag_check_port)            //10ms
    {
        flag_check_port = 0;
        ResultADC.W = 0;

        ADC_Channel_Select(ADC_AIN0);    //P10 is VBUS

        for (i = 0; i < 4; i++)
        {
            ADC_StartConversion();        //detect CC pin voltage

            while (ADC_GetConversionFlag() == DRV_Clr);

            ADC_ClearFlag();
            ResultADC.W += ADC_GetConversionData();
        }

        if (ResultADC.W > VBUS_MIN)
        {
            Vbus_onDebounce++;
            Vbus_offDebounce = 0;

            if (Vbus_onDebounce == 0)   //overflow
                Vbus_onDebounce--;
        }
        else
        {
            Vbus_offDebounce++;
            Vbus_onDebounce = 0;

            if (Vbus_offDebounce == 0)   //overflow
                Vbus_offDebounce--;
        }


        if (Vbus_onDebounce >= 15)            //Vbus on tVBUSON 0 ~ 275ms
            pd_set_state(PD_STATE_SNK_DISCOVERY);

        else if (Vbus_offDebounce >= 25)
        {
            pd_set_state(PD_STATE_SNK_DISCONNECTED);    //Vbus off tVBUSOFF 0 ~ 650ms
            EIE1 &= ~ES1;        //Enable UART1 Interrupt
        }

    }

}

U16 get_ccpin_voltage(U8 PIN)
{
    U8 i;
    U16 ResultADC;
    ResultADC = 0;
    ADC_Channel_Select(PIN);    //ADC Channel CC1 or CC2 pin

    for (i = 0; i < 4; i++)
    {
        ADC_StartConversion();        //detect CC pin voltage

        while (ADC_GetConversionFlag() == DRV_Clr);

        ADC_ClearFlag();
        ResultADC += ADC_GetConversionData();
    }

    ResultADC = ResultADC >> 2;      //ResultADC/4 ,average
    return ResultADC;
}

void Check_USB_Port_Status()
{
    U16 cc1_v, cc2_v;

    SFRPI = 1;

    if (PD_Communication_Status == TRANSFER || PD_Communication_Status == RECEIVE || ((S1CFG6 & M6IDL1) == 0))
    {
        SFRPI = 0;          //CC bus not idle
        return;
    }

    SFRPI = 0;

    switch (USB_Port_Status)
    {
        case UNKNOWN_DEVICE:    //tCCDebounce 100ms~200ms

            if (flag_check_port)
            {
                flag_check_port = 0;

                cc1_v = get_ccpin_voltage(CC1_PIN);

                cc2_v = get_ccpin_voltage(CC2_PIN);

                if ((cc1_v < VRa_MAX) && (cc2_v < VRa_MAX))       //<0.15V
                {

                    Check_USB_vbus();
                    CCDebounce = 0;                       //Unknown power source
                    DetectDevice = UNKNOWN_DEVICE;
                    break;
                }

                if (cc1_v > VRa_MAX)    //Check cc1
                {
                    if ((cc1_v >= DEFAULT_USB_MIN) && (cc1_v <= DEFAULT_USB_MAX))
                    {

                        if (DetectDevice == DEFAULT_USB_CC1)       // Default USB power
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = DEFAULT_USB_CC1;
                        }
                    }
                    else if ((cc1_v >= POWER_1P5A_MIN) && (cc1_v <= POWER_1P5A_MAX))
                    {

                        if (DetectDevice == POWER5V_1P5A_CC1)       // Power 5V 1.5A
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = POWER5V_1P5A_CC1;
                        }
                    }
                    else if ((cc1_v  >= POWER_3A_MIN) && (cc1_v <= POWER_3A_MAX))
                    {

                        if (DetectDevice == POWER5V_3A_CC1)       // Power 5V 3A
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = POWER5V_3A_CC1;
                        }
                    }
                }
                else            //Check cc2
                {
                    if ((cc2_v >= DEFAULT_USB_MIN) && (cc2_v <= DEFAULT_USB_MAX))
                    {

                        if (DetectDevice == DEFAULT_USB_CC2)       // Default USB power
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = DEFAULT_USB_CC2;
                        }
                    }
                    else if ((cc2_v >= POWER_1P5A_MIN) && (cc2_v <= POWER_1P5A_MAX))
                    {

                        if (DetectDevice == POWER5V_1P5A_CC2)       // Power 5V 1.5A
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = POWER5V_1P5A_CC2;
                        }
                    }
                    else if ((cc2_v  >= POWER_3A_MIN) && (cc2_v <= POWER_3A_MAX))
                    {

                        if (DetectDevice == POWER5V_3A_CC2)       // Power 5V 3A
                            CCDebounce++;
                        else
                        {
                            CCDebounce = 0;
                            DetectDevice = POWER5V_3A_CC2;
                        }
                    }
                }


                if (CCDebounce >= 9)  //~90ms      //min Debounce 100ms.  but Apple charger 100ms send pd package, so debounce reduce 10ms
                {

                    CCDebounce = 0;

                    if (DetectDevice != UNKNOWN_DEVICE)
                    {
                        USB_Port_Status = DetectDevice;
                        pd_set_state(PD_STATE_SNK_DISCOVERY);
                        EIE1 |= ES1;        //Enable UART1 Interrupt
                    }


                }
            }

            break;

        case DEFAULT_USB_CC1:

            Check_Rp(CC1_PIN);
            TXD1_1 = 0;
            break;

        case POWER5V_1P5A_CC1:

            Check_Rp(CC1_PIN);
            TXD1_1 = 0;
            break;


        case POWER5V_3A_CC1:

            Check_Rp(CC1_PIN);
            TXD1_1 = 0;
            break;

        case DEFAULT_USB_CC2:

            Check_Rp(CC2_PIN);
            break;

        case POWER5V_1P5A_CC2:

            Check_Rp(CC2_PIN);
            break;


        case POWER5V_3A_CC2:

            Check_Rp(CC2_PIN);
            break;

        default:
            break;
    }

}
U8 pd_handle_data_message(U8 Msg_Type)    //data message
{

    switch (Msg_Type)
    {
        case PD_SOURCE_CAPABILITIES:
            if ((pd_state == PD_STATE_SNK_DISCOVERY) || (pd_state == PD_STATE_SNK_TRANSITION) || (pd_state == PD_STATE_SNK_READY))
            {

                // Port partner are known to have PD capabilities
                pd_flags |= PD_FLAGS_PREVIOUS_PD_CONN;
                pd_process_source_cap();
                pd_set_state(PD_STATE_SNK_REQUESTED);
                pd_new_request = 1;

            }

            return 1;
            break;
        case PD_SINK_CAPABILITIES:
            if (pd_state == PD_STATE_SNK_READY)
            {
                pd_send_data_msg(PD_SINK_CAPABILITIES);
            }
            return 1;
            break;

        default:

            if (PD_Communication_Status == IDLE)
            {
                pd_send_control_msg(PD_NOT_SUPPORTED);

                return 1;
            }
            else
                return 0;

            break;


    }

}

void pd_handle_control_message(U8 Msg_Type)    //control message
{

    switch (Msg_Type)
    {
        case PD_GOTOMIN:
            if (pd_state == PD_STATE_SNK_READY)
            {
                // Reduce power consumption
                pd_set_state(PD_STATE_SNK_TRANSITION);
            }
            break;

        case PD_PS_RDY:

            if (pd_state == PD_STATE_SNK_DISCOVERY)
            {

                // hard Reset.
                pd_set_state(PD_STATE_HARD_RESET_SEND);
            }
            else
            {

                pd_set_state(PD_STATE_SNK_READY);
                pd_flags |= PD_FLAGS_VBUS_PR_RDY;
                timeout_counter = 0;    //no time limit
            }

            break;
        case PD_ACCEPT:

            if (pd_state == PD_STATE_SOFT_RESET)
            {

               //Because VBUS is never low, we are sending a soft reset when entering SNK_DISCOVERY, so please clear this flag.

                pd_flags &= ~PD_FLAGS_VBUS_NEVER_LOW;
                pd_set_state(PD_STATE_SNK_DISCOVERY);
            }

            else if (pd_state == PD_STATE_SNK_REQUESTED)
            {

                // Explicit Contract in place
                pd_new_request = 0;
                set_input_current_limit(get_src_pdo_fixedsupply_maxcurr(PD_Source_PDO[pdo_index].DW));
                pd_flags |= PD_FLAGS_EXPLICIT_CONTRACT;
                pd_set_state(PD_STATE_SNK_TRANSITION);

            }

            break;
            
        case PD_REJECT:
        case PD_WAIT:
            if (pd_state == PD_STATE_SNK_REQUESTED)
            {
                
                 //  Explicit Contract in place
                
                if (pd_flags & PD_FLAGS_EXPLICIT_CONTRACT)
                {
                    // We have an explicit contract 
                    pd_flags &= ~PD_FLAGS_VBUS_PR_RDY;
                    if (Msg_Type == PD_WAIT)
                    {
                       //Make a new power request and enter PD_STATE_SNK_READY
                        pd_new_request = 1;
                        set_timeout_state(PD_TIME_SINK_REQUEST, PD_STATE_SNK_READY);
                    }
                    else
                    {
                        // The request is reject
                        pd_new_request = 1;
                        
                    }
                }
                else
                {
                    // No explicit contract
                    pd_set_state(PD_STATE_SNK_DISCOVERY);
                }
            }

            break;

        

        case PD_SOFT_RESET:

            pd_set_state(PD_STATE_SNK_DISCOVERY);
            // Soft start completed Send Accept packet 
            pd_send_control_msg(PD_ACCEPT);
            break;

        case PD_DR_SWAP:

            pd_send_control_msg(PD_REJECT);
            break;
        case PD_PR_SWAP:

            pd_send_control_msg(PD_REJECT);
            break;
        
        case PD_VCONN_SWAP:

            pd_send_control_msg(PD_REJECT);
            break;
        case PD_PING:

            break;
        case PD_GOODCRC:

            break;
        case PD_NOT_SUPPORTED:
          
            break;
        case PD_GET_SINK_CAP:
            
            break;
        default:

            pd_send_control_msg(PD_NOT_SUPPORTED);
            break;
    }

}

//USB PD sink state machine
void pd_protocol()
{


    switch (pd_state)
    {
        

        case PD_STATE_SNK_DISCOVERY:

            if (pd_last_state != PD_STATE_SNK_DISCONNECTED)
                set_input_current_limit(0);
            pdo_index = 0;
            Select_mode = MODE_5V;
            break;
            
        case PD_STATE_SNK_DISCONNECTED:

            break;
        
        case PD_STATE_SNK_REQUESTED:
            //The SINK made a request

            if ((pd_new_request == 1) && (PD_Communication_Status == IDLE))
            {

                
                timeout_counter = 0;        //without timeout

                pd_send_request_msg(pdo_index);
                pd_new_request = 0;


            }

            break;

         case PD_STATE_SNK_READY:

            if ((pd_flags & PD_TX_RETRY) && (retry_counter >= 3))
            {
                pd_flags &= ~PD_TX_RETRY;
                retry_counter = 0;
                pd_set_state(PD_STATE_SOFT_RESET);
            }

            break;
            
        case PD_STATE_SNK_TRANSITION:

            // Wait PS_RDY
            if (pd_last_state != pd_state)
            {
                pd_set_state(PD_STATE_SNK_TRANSITION);
                set_timeout_state(500, PD_STATE_HARD_RESET_SEND);
            }
            break;

       
        case PD_STATE_HARD_RESET_SEND:

            pd_send_hard_reset();

            break;
        
        case PD_STATE_SOFT_RESET:

            if (pd_last_state != pd_state)
            {
                // Send soft reset 
                // MessageID for soft reset is always 0
                pd_set_state(PD_STATE_SOFT_RESET);
                pd_messageid = 0;
                pd_send_control_msg(PD_SOFT_RESET);
                return;
            }

            break;
       default:

      
            break;

    }

    if (timeout_counter != 0)
    {

        if (Timer_ms > timeout_counter)
        {
            pd_set_state(timeout_state);
            timeout_counter = 0;
        }
    }


    //There are received packets, which will be processed
    if (pd_flags & PD_FLAGS_RX_PACKET)
    {

        if (get_header_field(DATA_OBJECTS))
        {
            if (pd_handle_data_message((U8) get_header_field(MSG_TYPE)))
                pd_flags &= ~PD_FLAGS_RX_PACKET;
        }
        else
        {
            pd_handle_control_message((U8) get_header_field(MSG_TYPE));
            pd_flags &= ~PD_FLAGS_RX_PACKET;
        }

    }


}
void time()
{

    if (Timer_10ms >= 10)
    {

        flag_check_port = 1;
        Timer_10ms = 0;
        Flag_10ms = 1;
    }

    if (Flag_10ms == 0)
        return;

    Flag_10ms = 0;


    if (Flag_select_mode)
    {
        Timer_500ms++;

        if (Timer_500ms >= 50)
        {

            Flag_500ms = 1;
            Timer_500ms = 0;
            Timeout_select++;

            if (Timeout_select > 10)   // 10=5sec time out
            {
                Flag_select_mode = 0;
                Select_mode = pdo_index;
            }

        }
    }
    else
        Timer_500ms = 0;
}


void Run_USBPD()
{
    led_state();
    key_state();
    Check_USB_Port_Status();
    time();
    pd_protocol();
}


